/*
 Copyright (C) 1997, Alexander Pukhov 
*/

#include<stdlib.h>
#include<stdio.h>
#include<usrfun.h>
#include"interface.h"

/*                FOR USER 

The given file contains a dummy version of 
                SQMEUSR
function which should be  replaced by other ones written by the user.
We expect that the user version will be attached to calchep numerical code
as  via 'Libraries' model file, while the current dummy version will 
be kept unchanged. 

We assume that the uses has compiled  some processes in CalCHEP but would 
like to replace CalcHEP squared matrix element on his own one. Thus all routines 
and structures mentioned in c_source/num/unclude/interface.h continue to work but  
 
       double sqme_int(int nsub, double GG,REAL*pvect,REAL*cb_coeff, int * err)  
generated by CalcHEP  is replaced on 
       double SQMEUSR(int nsub, double GG,REAL*pvect,REAL*cb_coeff, int * err)
written by the user. 
 
Besides of SQMEUSR    user's  file has to contain flag 
      int const SQMEUSRFLAG=1;  
which is an instruction to CalcHEP to use external matrix element. 
These flag and routine has to be passed to CalcHEP linker using extlib model file in 
the way explained  for usrFF and usrfun functions.
      
Arguments of SQMEUSR are 
   nsub - serial number of subprocess. It changes  from 1 to  nprc_int.
   
  

   GG is a QCD strong coupling passed to SQMEUSR

   pvect - array of 4*(nin+nout) elements which presents particle momenta. Energy 
   is presented  in first position of each 4 and always is  positive. Type REAL is 
   defined in include/nType.h. It could be double, long double, or _QUAD.     
     
   Parameter cb_coeff is an arrray which returns to CalcHEP contribution  of 
   different  elements of color chain basis. During integration of matrix element 
   CalcHEP substitutes NULL value for this parameters. Color basis needs only 
   for  event generation. Number of elements in color basis  is defined by parameter 
   cb_int->pow. If color structure of matrix element is not known, then the user can
   fill this array by random rumbers, cheching preliminaly that  cb_coeff!=NULL. 
   For more precise treatment the user has to know structure  of color basis presented below.

 To get names of particles and their masses for each subprocesses one  has to call 
          char * (*pinf_int)(int nsub, int nprtcl,  REAL* pmass, int*pnum);
where  nprtcl is a position  of particle in subprocess, the return parameter pnum is its PDG code.
momenta are defined in the same manner as for usrFF and usrfun.   
   
Color basis is  defined by structure 
   
   typedef  struct  { int pow; int nC; int * chains;} colorBasis;
   extern colorBasis cb_int[];  

For each subrocesses we have its own color basis  cb_int[nsub-1]
Each of element of colour basis is presented by a chain of cb_int[nsub-1]->nC elements.
Each element  in its turn is presented by  4 integer numbers.  The first number gives
number of legs. It can be 2 or 3. Other numbers present particles included in one element.
Typically each element of chain connects 2 particles and the last number is zero. Element 
with 3 legs is used to describe 333 color vertex.
Finaly the basis presented by array cb_int[nsub-1]->chains which contains 
            cb_int[nsub-1]->pow*cb_int[nsub-1]->nC 
numbers. For example, for G,G -> u,U process 
    
   cb_int= { 
             {  { 3, 3},    
               {
                 2,1,2,0 , 2,2,1,0 , 2,4,3,0 ,
                 2,1,3,0 , 2,2,1,0 , 2,4,2,0 ,
                 2,1,2,0 , 2,2,3,0 , 2,4,1,0
                }
             }
           }; 

Exapmle: File xxx.c 
~~~~~~          
#include"../c_source/num/include/interface.h"

double SQMEUSR(int nsub, double GG,REAL*pvect,REAL*cb_coeff, int * err){ *err=0; return 1;}
int const SQMEUSRFLAG=1;
~~~~~
Compilation in work/ directory
 gcc -c -I ../include xxx.c  

Record in extlib#.mdl 
../xxx.o 

          
*/

                                                                
double SQMEUSR(int nsub, double GG,REAL*pvect,REAL*cb_coeff, int * err){ *err=100; return 0;}
int const SQMEUSRFLAG=0;
 